﻿/*
WHAT THIS DOES:
	This moves a moveClip a specified amount of tiles, relative to it's current location.
	
PARAMETERS:
	moveSystem		(needed)		The event system for this sequence of movements.		Used to determine which sprite to use.		Used to trigger next movement / event.
	xDist					(optional)		Relative amount of tiles to move horz.
	yDist					(optional)		Relative amount of tiles to move vert.
	autoPose			(optional)		Whether to automatically set the sprite's direction  &  animation.
	speed				(optional)		How many seconds it takes to move 1 tile.
	
USAGE:
(synchronous)		(sequence of movements)
	talkEvents.push( function(){			move = makeEventSystem( _this );		// define movement
														move.push( function(){			event_move(move, -1, 0);		});
														move.push( function(){			event_move(move, 0, -1);		});
														move.push( function(){			event_move(move, 1, 0);		});
														move.push( function(){			event_move(move, 0, 1);		});
														move.push( function(){			_this.image_mc.setAnim( false );
																									talkEvents.nextEvent();		});
													move.runEvent(0);								// start movement
													});
	
USAGE:
(asynchronous)		(sequence of movements)
	talkEvents.push( function(){			move = makeEventSystem( _this );		// define movement
														move.push( function(){			event_move(move, -1, 0);		});
														move.push( function(){			event_move(move, 0, -1);		});
														move.push( function(){			event_move(move, 1, 0);		});
														move.push( function(){			event_move(move, 0, 1);		});
														move.push( function(){			_this.image_mc.setAnim( false );		});
													move.runEvent(0);								// start movement
													talkEvents.nextEvent();		});
	
USAGE:
(a single movement)
	talkEvents.push( function(){		event_move(talkEvents, -1, 0);		});
	
EXPLAINATION:
	To create a sequence of movements, simply define a 2nd eventSystem and run it.
	When defining it, tell it which sprite to move like so:
		move = makeEventSystem( mySprite_mc );
	
NOTE:
	Any event command can be placed within the movement sequence.
	Likewise, a single move command can be used as a normal event.
	
NOTE:
	autoPose will make the sprite start animating,
	but it won't make it stop.
	You need to do that manually.
*/
if(!ZigoEngine)
{
	import com.mosesSupposes.fuse.*;
	ZigoEngine.simpleSetup(Shortcuts,PennerEasing);
}



_global.event_move = function( moveSystem, xDist, yDist, autoPose, speed, thisSprite )
{
	// resolve optional parameters
	var xDist = (xDist) ? xDist : 0;							// default:  don't move
	var yDist = (yDist) ? yDist : 0;							// default:  don't move
	var autoPose = (autoPose!=undefined) ? autoPose : true;	// default:  ON
	var speed = (speed) ? speed : 0.26;					// default:  0.26 seconds to move 1 tile
	var thisSprite = (thisSprite) ? thisSprite : moveSystem.sprite;		// default:  calling sprite
	
	if(autoPose)
	{
		if(yDist < 0){	thisSprite.image_mc.setDirection("up");		}
		if(yDist > 0){	thisSprite.image_mc.setDirection("down");		}
		if(xDist < 0){	thisSprite.image_mc.setDirection("left");		}
		if(xDist > 0){	thisSprite.image_mc.setDirection("right");		}
		if( xDist  ||  yDist ){
			thisSprite.image_mc.setAnim( true );
		}
	}// if:  autoPose
	
	// set destination coordinates
	var xPix = thisSprite._x  +  (xDist*16);
	var yPix = thisSprite._y  +  (yDist*16);
	
	// calculate time
	var dist = Math.sqrt( (xDist*xDist) + (yDist*yDist) );		// overall distance being traveled
	var delay = speed * dist;
	
	// do movement
	thisSprite.slideTo( xPix, yPix, delay, "linear", 0, moveSystem.nextEvent );
}// event_move()